package furny.ga.test;

import math.geom2d.Point2D;
import math.geom2d.line.LineSegment2D;
import math.geom2d.polygon.Polygon2D;
import math.geom2d.polygon.Rectangle2D;
import math.geom2d.polygon.SimplePolygon2D;

public class TestJavaGeom {

  private TestJavaGeom() {
  }

  public static void main(final String[] args) {
    final Polygon2D r = new Rectangle2D(-1, -1, 2, 2);

    final Polygon2D r2 = new Rectangle2D(3, 3, 1, 1);

    for (final Point2D p : r2.getVertices()) {
      final double dist = r.getDistance(p);

      System.out.println(dist);
    }

    System.out.println();

    final Polygon2D poly = new SimplePolygon2D(new double[] { 3, 4, 4, 3 },
        new double[] { 3, 3, 4, 4 });

    for (final Point2D p : poly.getVertices()) {
      final double dist = r.getDistance(p);

      System.out.println(dist);
    }

    for (final LineSegment2D ls : poly.getEdges()) {
      System.out.println(ls);
      System.out.println(ls.getHorizontalAngle());
    }

    System.out.println(r2.getBoundingBox().containsBounds(poly));
  }
}
